/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.ui;

import com.ibm.hwmca.fw.ui.UIInfo;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public abstract class UIStyle
implements Serializable {
    public static final String UI_URI = "/ui";
    private UIInfo uiInfo;
    private String identifier;
    private String initialURI;
    private HashMap servletClassNames = new HashMap();
    private HashMap servletURIs = new HashMap();

    public UIInfo getUIInfo() {
        if (this.uiInfo == null) {
            throw new IllegalStateException("UIInfo is null.");
        }
        return this.uiInfo;
    }

    protected void setUIInfo(UIInfo uiInfo) {
        this.uiInfo = uiInfo;
    }

    public Set getServletNames() {
        if (this.servletClassNames == null || this.servletClassNames.isEmpty() || this.servletURIs == null || this.servletURIs.isEmpty()) {
            return new HashSet(0);
        }
        return this.servletClassNames.keySet();
    }

    public String getServletClassName(String name) throws IllegalStateException {
        if (this.servletClassNames == null || this.servletClassNames.isEmpty()) {
            throw new IllegalStateException("The servlet name to servlet class name map is empty or null.");
        }
        return (String)this.servletClassNames.get(name);
    }

    public String getServletURI(String name) throws IllegalStateException {
        if (this.servletURIs == null || this.servletURIs.isEmpty()) {
            throw new IllegalStateException("The servlet name to servlet URI map is empty or null.");
        }
        return (String)this.servletURIs.get(name);
    }

    public String getInitialURI() {
        if (this.initialURI == null) {
            throw new IllegalStateException("The initial URI is null.");
        }
        return this.initialURI;
    }

    public final String getIdentifier() {
        if (this.identifier == null) {
            throw new IllegalStateException("Class " + this.getClass() + " did not set the identifier.");
        }
        return this.identifier;
    }

    public boolean isColorsPatternsSupported() {
        return false;
    }

    protected void setIdentifier(String identifier) {
        if (identifier == null || identifier.length() == 0) {
            throw new IllegalArgumentException("The identifier argument is null or an empty string.");
        }
        this.identifier = identifier;
    }

    protected void setInitialURI(String initialURI) {
        this.initialURI = UI_URI + initialURI;
    }

    protected void addMapping(String name, String uri, String className) {
        this.servletURIs.put(name, UI_URI + uri);
        this.servletClassNames.put(name, className);
    }
}

